<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

require_once 'vendor/autoload.php'; // Make sure PHPMailer is installed via Composer

class Model {

    // Database credentials
    public static $host = "localhost";
    public static $dbName = "kpoiiumd_kpoint";          // Your database name
    public static $username = "kpoiiumd_kpoint";        // Your DB username
    public static $password = "kpoiiumd_kpoint";        // Your DB password

    public static $dbh;

    // Email credentials
    public $emailUsername = "support@databservices.com.ng";
    public $emailPassword = "Databservices@1";

    public $sitename = "KPOINT";

    public function __construct() {
        $this->dbh = $this->connectDb();
    }

    public function connectDb() {
        try {
            $pdo = new PDO(
                "mysql:host=" . self::$host . ";dbname=" . self::$dbName,
                self::$username,
                self::$password
            );
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            return $pdo;
        } catch (PDOException $e) {
            die("DB Connection Failed: " . $e->getMessage());
        }
    }

    public function connect() {
        return $this->dbh;
    }

    // Send email via SMTP
    public function sendMail($to, $subject, $message) {
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host       = $_SERVER['SERVER_NAME'];
            $mail->SMTPAuth   = true;
            $mail->Username   = $this->emailUsername;
            $mail->Password   = $this->emailPassword;
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port       = 465;

            $mail->setFrom($this->emailUsername, $this->sitename);
            $mail->addAddress($to);

            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body    = $message;
            $mail->AltBody = strip_tags($message);

            $mail->send();
            return ['status' => 'success'];
        } catch (Exception $e) {
            return ['status' => 'error', 'message' => $mail->ErrorInfo];
        }
    }

    // Get site config (if needed)
    public function getSiteConfiguration() {
        $sql = "SELECT * FROM sitesettings WHERE sId = 1";
        $stmt = $this->connect()->prepare($sql);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_OBJ);
    }

    // Get API configuration (if needed)
    public function getApiConfiguration() {
        $sql = "SELECT * FROM apiconfigs";
        $stmt = $this->connect()->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_OBJ);
    }

    public function __destruct() {
        $this->dbh = null;
    }
}
