<!DOCTYPE HTML>
<html lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1, maximum-scale=1, viewport-fit=cover" />
<title>Login</title>

<link rel="stylesheet" type="text/css" href="../assets/styles/bootstrap.css">
<link rel="stylesheet" type="text/css" href="../assets/styles/style.css">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
<link rel="stylesheet" type="text/css" href="../assets/fonts/css/fontawesome-all.min.css">    
<link rel="manifest" href="../assets/scripts/_manifest.json">
<link rel="apple-touch-icon" sizes="180x180" href="../../assets/img/favicon.png">
<link rel="icon" type="image/png" href="../../assets/img/favicon.png" />

<?php if(isset($_SESSION['loginId'])){echo "<script>window.location.href='../home/';</script>"; } ?>

<style>
/* Premium full background */
body{
    background: <?php echo $color; ?>;
    background-size: cover;
    background-attachment: fixed;
    font-family: 'Inter', sans-serif;
}

/* Premium card look (NO card color change – stays rgba(0,0,0,0.5)) */
.card{
    background: rgba(0,0,0,0.5) !important;
    backdrop-filter: blur(12px);
    -webkit-backdrop-filter: blur(12px);
    border-radius: 25px;
    border: 1px solid rgba(255,255,255,0.15);
    box-shadow: 0 8px 35px rgba(0,0,0,0.35);
    animation: fadeIn 0.7s ease-out;
    padding-bottom: 25px;
}
<style>
.login-logo {
    width: 110px;
    height: 110px;
    border-radius: 0 !important;       /* remove rounded corners */
    box-shadow: none !important;       /* remove shadow */
    animation: none !important;        /* remove pop animation */
    display: block;
    margin: 0 auto;                    /* horizontal center */
    object-fit: cover;
}

/* Optional: center vertically within its container */
.card .content {
    display: flex;
    flex-direction: column;
    align-items: center;  /* horizontal center */
    justify-content: center; /* vertical center */
}


}

/* Inputs */
.form-control{
    background-color: #fafafa !important; 
    border-radius: 5rem !important;
    padding:25px !important;
    padding-left: 50px !important;
}
.form-control:focus{
    background-color: #ffffff !important; 
    box-shadow: 0 0 12px rgba(255,255,255,0.35) !important;
}

/* Icons inside inputs */
.input-style i{
    padding-left: 20px !important;
}

/* Button */
.btn{
    border-radius: 5rem !important;
    background-image: linear-gradient(to bottom, <?php echo $color; ?>, <?php echo $color; ?>) !important;
    box-shadow: 0px 0px 12px <?php echo $color; ?>;
    transition: 0.2s;
}
.btn:hover{
    transform: scale(1.03);
}

/* Highlight color */
.color-highlight{
    color: <?php echo $color; ?> !important;
}

/* Animations */
@keyframes fadeIn {
    from {opacity: 0; transform: translateY(20px);}
    to {opacity: 1; transform: translateY(0);}
}
@keyframes logoPop {
    0% {transform: scale(0.5); opacity: 0;}
    100% {transform: scale(1); opacity: 1;}
}
</style>

</head>
<body class="theme-light">

<div id="preloader"><div class="spinner-border color-highlight" role="status"></div></div>

<div id="page">
<div class="page-content mt-3">

<div style="display:flex; justify-content:center; align-content:center;">
    <div class="card card-style">
        <div class="content">

            <!-- LOGO -->
            <img src="https://chrispay.com.ng/IMG-20250919-WA0007-removebg-preview.png"width="100" class="login-logo" alt="LOGO">
            <br>

            <div class="text-center">
                <h2 class="mb-2 text-white" id="accountname">Welcome Back</h2>
                <h1 class="font-25 mb-3 text-white" id="accountname2">
                    Login To <br/> <?php echo strtoupper($name); ?>
                </h1>
            </div>
                
            <form id="login-form" method="post">
            <div class="px-2">
                
                <div class="input-style no-borders has-icon mb-4" id="phonediv">
                    <i class="fa fa-phone"></i>
                    <input type="number" class="form-control" id="phonelogin" name="phone" placeholder="Phone Number" required readonly />
                    <label class="color-highlight">Phone</label>
                    <em>(required)</em>
                </div>

                <div class="input-style no-borders has-icon mb-4">
                    <i class="fa fa-lock"></i>
                    <input type="password" class="form-control" id="passwordlogin" name="password" placeholder="Password" required readonly />
                    <label class="color-highlight">Password</label>
                    <em>(required)</em>
                </div>

                <button type="submit" id="submit-btn" style="width: 100%;" class="btn btn-full btn-l font-600 font-15 gradient-highlight mt-4">
                    Login
                </button>

                <div class="row pt-4 mb-3">
                    <div class="col-12 text-center font-15">
                        <a class="text-white" href="../recovery/">Forget Password? Recover It</a> 
                    </div>
                    <div class="col-12 text-center font-15 mt-2">
                        <a class="text-white" href="../register/">New User? Create Account</a>
                    </div>
                </div>

            </div>
            </form>

        </div>
    </div>
</div>
</div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script type="text/javascript" src="../assets/scripts/bootstrap.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script type="text/javascript" src="../assets/scripts/custom.js"></script>

<script>
$("document").ready(function(){

    checkIfPhoneNumberSaved();

    $("#phonelogin").click(function(){$(this).removeAttr("readonly"); });
    $("#passwordlogin").click(function(){$(this).removeAttr("readonly"); });

    $('#login-form').submit(function(e){
        e.preventDefault();
        $('#submit-btn').removeClass("gradient-highlight").addClass("btn-secondary").html('<i class="fa fa-spinner fa-spin"></i> Processing ...');
        
        $.ajax({
            url:'../home/includes/route.php?login',
            data: new FormData($(this)[0]),
            cache: false,
            contentType: false,
            processData: false,
            method: 'POST',
            success:function(resp){
                resp = JSON.parse(resp);

                if(resp.status == "success"){
                    swal('Alert!!',"Login Successful","success");
                    setTimeout(function(){ location.replace('../home/') },1000)
                } else {
                    swal('Alert!!',resp.msg,"error");
                }

                $('#submit-btn').removeClass("btn-secondary").addClass("gradient-highlight").html("Login");
            }
        });
    });

});

function checkIfPhoneNumberSaved() {
    $phone = atob(unescape(getCookie("loginPhone")));
    $name = atob(unescape(getCookie("loginName")));
    if($phone != null && $phone != ""){
        let msg='<p class="mb-3"><a href="javascript:showNumber();"><b class="text-white">Login With Another Account?</b></a></p>';
        $("#accountname2").after(msg);
        $("#accountname").append(" "+$name+"!");
        $("#phonediv").hide();
        $("#phonelogin").val($phone);
    }
}
function showNumber(){ $("#phonediv").show(); }

function getCookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i=0; i<ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1);
        if (c.indexOf(name) == 0) return c.substring(name.length,c.length);
    }
    return "";
}
</script>

</body>
</html>
