<!DOCTYPE HTML>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Login</title>

  <!-- Bootstrap & Font Awesome -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

  <style>
    body {
      font-family: 'Inter', sans-serif;
      background-color: #121212;
      background-image: url("https://media.istockphoto.com/id/1438316744/photo/a-young-beautiful-african-market-woman-feeling-happy-about-what-she-saw-on-her-cellphone.jpg?s=612x612&w=0&k=20&c=BSEObi9RDXgGy3dCQv57YgecL5So31bvSAmzsOk9si0=");
      background-size: cover;
      background-repeat: no-repeat;
      background-position: center;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
    }

    .card {
      background-color: rgba(18, 18, 18, 0.95);
      border: none;
      border-radius: 12px;
      padding: 40px 30px;
      max-width: 400px;
      width: 100%;
      box-shadow: 0 0 20px rgba(0,0,0,0.5);
    }

    .logo {
      width: 100px;
      margin: 0 auto 20px;
      display: block;
    }

    .card h2,
    .card h1 {
      color: #fff;
    }

    .input-group-text {
      background-color: #222;
      border: none;
      color: #9319d1;
    }

    .form-control {
      background-color: #1e1e1e;
      border: 1px solid #333;
      color: #fff;
    }

    .form-control:focus {
      background-color: #1e1e1e;
      color: #fff;
      border-color: #9319d1;
      box-shadow: 0 0 0 0.2rem rgba(147, 25, 209, 0.25);
    }

    label,
    em {
      color: #ccc;
      font-size: 13px;
    }

    .btn-login {
      background-color: #9319d1;
      color: white;
      border-radius: 50px;
      padding: 10px;
      font-weight: 600;
      transition: background 0.3s ease;
    }

    .btn-login:hover {
      background-color: #7d17b0;
    }

    .form-links a {
      color: #ccc;
      font-size: 14px;
      text-decoration: none;
    }

    .form-links a:hover {
      color: #9319d1;
    }

    .toggle-password {
      cursor: pointer;
      color: #9319d1;
    }
  </style>
</head>

<body>
  <div class="card text-center">
    <!-- Logo -->
    <img src="https://kpoint.com.ng/IMG-20250919-WA0007-removebg-preview.png" alt="Logo" class="logo">

    <h2 class="mb-2">Welcome Back</h2>
    <h1 class="mb-4">Login to <span style="color:#9319d1;"><?php echo strtoupper($name); ?></span></h1>

    <form id="login-form" method="POST">
      <!-- Phone -->
      <div class="mb-3">
        <div class="input-group">
          <span class="input-group-text"><i class="fa fa-phone"></i></span>
          <input type="number" class="form-control" id="phonelogin" name="phone" placeholder="Phone Number" required>
        </div>
        <em>(required)</em>
      </div>

      <!-- Password -->
      <div class="mb-3">
        <div class="input-group">
          <span class="input-group-text"><i class="fa fa-lock"></i></span>
          <input type="password" class="form-control" id="passwordlogin" name="password" placeholder="Password" required>
          <span class="input-group-text toggle-password"><i class="fa fa-eye" id="togglePasswordIcon"></i></span>
        </div>
        <em>(required)</em>
      </div>

      <!-- Button -->
      <button type="submit" id="submit-btn" class="btn btn-login w-100 mt-3">
        Login
      </button>

      <!-- Links -->
      <div class="form-links mt-4">
        <p><a href="../recovery/">Forgot Password? Recover it</a></p>
        <p><a href="../register/">New User? Create Account</a></p>
      </div>
    </form>
  </div>

  <!-- Scripts -->
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>

  <script>
    $(document).ready(function () {
      checkIfPhoneNumberSaved();

      // Toggle password visibility
      $('.toggle-password').on('click', function () {
        const passwordField = $('#passwordlogin');
        const icon = $('#togglePasswordIcon');
        const type = passwordField.attr('type') === 'password' ? 'text' : 'password';
        passwordField.attr('type', type);
        icon.toggleClass('fa-eye fa-eye-slash');
      });

      // Submit form via AJAX
      $('#login-form').submit(function (e) {
        e.preventDefault();
        $('#submit-btn').html('<i class="fa fa-spinner fa-spin"></i> Logging in...');

        $.ajax({
          url: '../home/includes/route.php?login',
          data: new FormData(this),
          cache: false,
          contentType: false,
          processData: false,
          method: 'POST',
          success: function (resp) {
            let res = JSON.parse(resp);
            if (res.status === "success") {
              swal('Success', "Login Successful", "success");
              setTimeout(() => location.href = '../home/', 1000);
            } else {
              swal('Error', res.msg, "error");
            }
            $('#submit-btn').html('Login');
          }
        });
      });
    });

    function checkIfPhoneNumberSaved() {
      let phone = atob(unescape(getCookie("loginPhone")));
      let name = atob(unescape(getCookie("loginName")));
      if (phone) {
        $('#phonelogin').val(phone);
        $('#phonediv').hide();
      }
    }

    function getCookie(name) {
      let value = "; " + document.cookie;
      let parts = value.split("; " + name + "=");
      if (parts.length === 2) return parts.pop().split(";").shift();
    }
  </script>
</body>
</html>
