<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      background-color: #f5f5f5;
    }

    #page {
      background-color: #f5f5f5;
      border-radius: 16px;
      box-shadow: 10px 10px 20px #cbced1, -10px -10px 20px #ffffff;
      padding: 30px;
      width: 250px;
      text-align: center;
    }

    #page h1 {
      margin-bottom: 20px;
      color: #FF5C1C ;
    }

    .input-style {
      margin-bottom: 30px;
      display: flex;
      align-items: center;
      border: none;
      border-radius: 8px;
      background-color: #f5f5f5;
      box-shadow: inset 5px 5px 8px #cbced1, inset -5px -5px 8px #ffffff;
      font-size: 16px;
      padding: 8px 12px;
    }

    .input-style input {
      flex: 1;
      border: none;
      background-color: transparent;
      margin-left: 8px;
    }

    #submit-btn {
      padding: 10px 15px;
      background-color: #FF5C1C;
      color: #fff;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      box-shadow: 5px 5px 8px #cbced1, -5px -5px 8px #ffffff;
    }

    #submit-btn:hover {
      background-color: #0056b3;
    }

    .text-center {
      text-align: center;
    }

    .text-dark {
      color: #555;
      margin-bottom: 10px;
    }
      .text-dark2 {
      color: #555;
      margin-top: 110px;
    }

    .mt-4 {
      margin-top: 16px;
    }

    .pt-5 {
      padding-top: 40px;
    }

    .pb-2 {
      padding-bottom: 8px;
    }

    .mb-3 {
      margin-bottom: 12px;
    }
  </style>
</head>
<body>
  <div id="preloader">
    <div class="spinner-border color-highlight" role="status"></div>
  </div>
  <div id="page">
    <div class="page-content mt-2">
      <div class="text-center">
        <div class="pb-2 pt-4">
          <img src="" class="img-fluid" width="250" />
        </div>
      </div>
      <div>
        <div class="card">
          <div class="content">
            <div class="text-center">
              <h1 class="font-30 mb-3">LOGIN</h1>
              <h2 class="mb-3 color-highlight" id="accountname">Welcome Back</h2>
            </div>
            <form id="login-form" method="post">
              <div class="px-2">
                <div class="input-style no-borders has-icon mb-4" id="phonediv">
                  <i class="fa fa-phone"></i>
                  <input type="number" class="form-control" id="phone" name="phone" placeholder="Phone Number" required readonly />
                 
                </div>
                <div class="input-style no-borders has-icon mb-4">
                  <i class="fa fa-lock"></i>
                  <input type="password" class="form-control" id="password" name="password" placeholder="Password" required readonly />
                
                 
                </div>
                <button type="submit" id="submit-btn" style="width: 100%;" class="btn btn-full btn-l font-600 font-15 gradient-highlight mt-4">Login</button>
                <div class="row pt-5 mb-3">
                  <div class="col-12 text-center font-15">
                    <a class="text-dark" href="../recovery/">Forget Password? Recover It</a>
                  </div>
                  <div class="col-12 text-center font-15 mt-2">
                    <a class="text-dark2" href="../register/">New User? Create Account</a>
                  </div>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
